# Installation
> `npm install --save @types/auto-launch`

# Summary
This package contains type definitions for auto-launch (https://github.com/Teamwork/node-auto-launch).

# Details
Files were exported from https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/auto-launch.
## [index.d.ts](https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/auto-launch/index.d.ts)
````ts
// Type definitions for auto-launch 5.0
// Project: https://github.com/Teamwork/node-auto-launch, https://github.com/4ver/node-auto-launch
// Definitions by: rhysd <https://github.com/rhysd>, Daniel Perez Alvarez <https://github.com/unindented>
// Definitions: https://github.com/DefinitelyTyped/DefinitelyTyped

interface AutoLaunchOptions {
  /**
   * Application name.
   */
  name: string;
  /**
   * Path to application. Default is `process.execPath`.
   */
  path?: string | undefined;
  /**
   * Hidden on launch. Default is `false`.
   */
  isHidden?: boolean | undefined;
  /**
   * For Mac-only options.
   */
  mac?: {
    /**
     * By default, AppleScript is used to add a Login Item. If this is `true`, Launch Agent will be used to auto-launch your app. Defaults is `false`.
     */
    useLaunchAgent?: boolean | undefined;
  } | undefined;
}

declare class AutoLaunch {
  constructor(options: AutoLaunchOptions);

  /**
   * Enables auto-launch at start up.
   */
  enable(): Promise<void>;
  /**
   * Disables auto-launch at start up.
   */
  disable(): Promise<void>;
  /**
   * Returns true if auto-launch is enabled.
   */
  isEnabled(): Promise<boolean>;
}

export = AutoLaunch;

````

### Additional Details
 * Last updated: Wed, 07 Jul 2021 21:44:39 GMT
 * Dependencies: none
 * Global values: none

# Credits
These definitions were written by [rhysd](https://github.com/rhysd), and [Daniel Perez Alvarez](https://github.com/unindented).
