import { getControlId } from './chunk-MKV36LKP.mjs';
import React, { useCallback, useState, useEffect, useMemo } from 'react';
import { HexColorPicker, RgbaStringColorPicker, HslaStringColorPicker } from 'react-colorful';
import convert from 'color-convert';
import debounce from 'lodash/debounce.js';
import { styled } from 'storybook/internal/theming';
import { WithTooltip, TooltipNote, Form } from 'storybook/internal/components';
import { MarkupIcon } from '@storybook/icons';

var Wrapper=styled.div({position:"relative",maxWidth:250,'&[aria-readonly="true"]':{opacity:.5}}),PickerTooltip=styled(WithTooltip)({position:"absolute",zIndex:1,top:4,left:4,"[aria-readonly=true] &":{cursor:"not-allowed"}}),TooltipContent=styled.div({width:200,margin:5,".react-colorful__saturation":{borderRadius:"4px 4px 0 0"},".react-colorful__hue":{boxShadow:"inset 0 0 0 1px rgb(0 0 0 / 5%)"},".react-colorful__last-control":{borderRadius:"0 0 4px 4px"}}),Note=styled(TooltipNote)(({theme})=>({fontFamily:theme.typography.fonts.base})),Swatches=styled.div({display:"grid",gridTemplateColumns:"repeat(9, 16px)",gap:6,padding:3,marginTop:5,width:200}),SwatchColor=styled.div(({theme,active})=>({width:16,height:16,boxShadow:active?`${theme.appBorderColor} 0 0 0 1px inset, ${theme.textMutedColor}50 0 0 0 4px`:`${theme.appBorderColor} 0 0 0 1px inset`,borderRadius:theme.appBorderRadius})),swatchBackground=`url('data:image/svg+xml;charset=utf-8,<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill-opacity=".05"><path d="M8 0h8v8H8zM0 8h8v8H0z"/></svg>')`,Swatch=({value,style,...props})=>{let backgroundImage=`linear-gradient(${value}, ${value}), ${swatchBackground}, linear-gradient(#fff, #fff)`;return React.createElement(SwatchColor,{...props,style:{...style,backgroundImage}})},Input=styled(Form.Input)(({theme,readOnly})=>({width:"100%",paddingLeft:30,paddingRight:30,boxSizing:"border-box",fontFamily:theme.typography.fonts.base})),ToggleIcon=styled(MarkupIcon)(({theme})=>({position:"absolute",zIndex:1,top:6,right:7,width:20,height:20,padding:4,boxSizing:"border-box",cursor:"pointer",color:theme.input.color})),ColorSpace=(ColorSpace2=>(ColorSpace2.RGB="rgb",ColorSpace2.HSL="hsl",ColorSpace2.HEX="hex",ColorSpace2))(ColorSpace||{}),COLOR_SPACES=Object.values(ColorSpace),COLOR_REGEXP=/\(([0-9]+),\s*([0-9]+)%?,\s*([0-9]+)%?,?\s*([0-9.]+)?\)/,RGB_REGEXP=/^\s*rgba?\(([0-9]+),\s*([0-9]+),\s*([0-9]+),?\s*([0-9.]+)?\)\s*$/i,HSL_REGEXP=/^\s*hsla?\(([0-9]+),\s*([0-9]+)%,\s*([0-9]+)%,?\s*([0-9.]+)?\)\s*$/i,HEX_REGEXP=/^\s*#?([0-9a-f]{3}|[0-9a-f]{6})\s*$/i,SHORTHEX_REGEXP=/^\s*#?([0-9a-f]{3})\s*$/i,ColorPicker={hex:HexColorPicker,rgb:RgbaStringColorPicker,hsl:HslaStringColorPicker},fallbackColor={hex:"transparent",rgb:"rgba(0, 0, 0, 0)",hsl:"hsla(0, 0%, 0%, 0)"},stringToArgs=value=>{let match=value?.match(COLOR_REGEXP);if(!match)return [0,0,0,1];let[,x,y,z,a=1]=match;return [x,y,z,a].map(Number)},parseValue=value=>{if(!value)return;let valid=!0;if(RGB_REGEXP.test(value)){let[r,g,b,a]=stringToArgs(value),[h,s,l]=convert.rgb.hsl([r,g,b])||[0,0,0];return {valid,value,keyword:convert.rgb.keyword([r,g,b]),colorSpace:"rgb",rgb:value,hsl:`hsla(${h}, ${s}%, ${l}%, ${a})`,hex:`#${convert.rgb.hex([r,g,b]).toLowerCase()}`}}if(HSL_REGEXP.test(value)){let[h,s,l,a]=stringToArgs(value),[r,g,b]=convert.hsl.rgb([h,s,l])||[0,0,0];return {valid,value,keyword:convert.hsl.keyword([h,s,l]),colorSpace:"hsl",rgb:`rgba(${r}, ${g}, ${b}, ${a})`,hsl:value,hex:`#${convert.hsl.hex([h,s,l]).toLowerCase()}`}}let plain=value.replace("#",""),rgb=convert.keyword.rgb(plain)||convert.hex.rgb(plain),hsl=convert.rgb.hsl(rgb),mapped=value;if(/[^#a-f0-9]/i.test(value)?mapped=plain:HEX_REGEXP.test(value)&&(mapped=`#${plain}`),mapped.startsWith("#"))valid=HEX_REGEXP.test(mapped);else try{convert.keyword.hex(mapped);}catch{valid=!1;}return {valid,value:mapped,keyword:convert.rgb.keyword(rgb),colorSpace:"hex",rgb:`rgba(${rgb[0]}, ${rgb[1]}, ${rgb[2]}, 1)`,hsl:`hsla(${hsl[0]}, ${hsl[1]}%, ${hsl[2]}%, 1)`,hex:mapped}},getRealValue=(value,color,colorSpace)=>{if(!value||!color?.valid)return fallbackColor[colorSpace];if(colorSpace!=="hex")return color?.[colorSpace]||fallbackColor[colorSpace];if(!color.hex.startsWith("#"))try{return `#${convert.keyword.hex(color.hex)}`}catch{return fallbackColor.hex}let short=color.hex.match(SHORTHEX_REGEXP);if(!short)return HEX_REGEXP.test(color.hex)?color.hex:fallbackColor.hex;let[r,g,b]=short[1].split("");return `#${r}${r}${g}${g}${b}${b}`},useColorInput=(initialValue,onChange)=>{let[value,setValue]=useState(initialValue||""),[color,setColor]=useState(()=>parseValue(value)),[colorSpace,setColorSpace]=useState(color?.colorSpace||"hex");useEffect(()=>{let nextValue=initialValue||"",nextColor=parseValue(nextValue);setValue(nextValue),setColor(nextColor),setColorSpace(nextColor?.colorSpace||"hex");},[initialValue]);let realValue=useMemo(()=>getRealValue(value,color,colorSpace).toLowerCase(),[value,color,colorSpace]),updateValue=useCallback(update=>{let parsed=parseValue(update),v=parsed?.value||update||"";setValue(v),v===""&&(setColor(void 0),onChange(void 0)),parsed&&(setColor(parsed),setColorSpace(parsed.colorSpace),onChange(parsed.value));},[onChange]),cycleColorSpace=useCallback(()=>{let next=COLOR_SPACES.indexOf(colorSpace)+1;next>=COLOR_SPACES.length&&(next=0),setColorSpace(COLOR_SPACES[next]);let update=color?.[COLOR_SPACES[next]]||"";setValue(update),onChange(update);},[color,colorSpace,onChange]);return {value,realValue,updateValue,color,colorSpace,cycleColorSpace}},id=value=>value.replace(/\s*/,"").toLowerCase(),usePresets=(presetColors,currentColor,colorSpace)=>{let[selectedColors,setSelectedColors]=useState(currentColor?.valid?[currentColor]:[]);useEffect(()=>{currentColor===void 0&&setSelectedColors([]);},[currentColor]);let presets=useMemo(()=>(presetColors||[]).map(preset=>typeof preset=="string"?parseValue(preset):preset.title?{...parseValue(preset.color),keyword:preset.title}:parseValue(preset.color)).concat(selectedColors).filter(Boolean).slice(-27),[presetColors,selectedColors]),addPreset=useCallback(color=>{color?.valid&&(presets.some(preset=>id(preset[colorSpace])===id(color[colorSpace]))||setSelectedColors(arr=>arr.concat(color)));},[colorSpace,presets]);return {presets,addPreset}},ColorControl=({name,value:initialValue,onChange,onFocus,onBlur,presetColors,startOpen=!1,argType})=>{let debouncedOnChange=useCallback(debounce(onChange,200),[onChange]),{value,realValue,updateValue,color,colorSpace,cycleColorSpace}=useColorInput(initialValue,debouncedOnChange),{presets,addPreset}=usePresets(presetColors,color,colorSpace),Picker=ColorPicker[colorSpace],readonly=!!argType?.table?.readonly;return React.createElement(Wrapper,{"aria-readonly":readonly},React.createElement(PickerTooltip,{startOpen,trigger:readonly?[null]:void 0,closeOnOutsideClick:!0,onVisibleChange:()=>addPreset(color),tooltip:React.createElement(TooltipContent,null,React.createElement(Picker,{color:realValue==="transparent"?"#000000":realValue,onChange:updateValue,onFocus,onBlur}),presets.length>0&&React.createElement(Swatches,null,presets.map((preset,index)=>React.createElement(WithTooltip,{key:`${preset.value}-${index}`,hasChrome:!1,tooltip:React.createElement(Note,{note:preset.keyword||preset.value})},React.createElement(Swatch,{value:preset[colorSpace],active:color&&id(preset[colorSpace])===id(color[colorSpace]),onClick:()=>updateValue(preset.value)})))))},React.createElement(Swatch,{value:realValue,style:{margin:4}})),React.createElement(Input,{id:getControlId(name),value,onChange:e=>updateValue(e.target.value),onFocus:e=>e.target.select(),readOnly:readonly,placeholder:"Choose color..."}),value?React.createElement(ToggleIcon,{onClick:cycleColorSpace}):null)},Color_default=ColorControl;

export { ColorControl, Color_default as default };
