import { convertIntegrationFnToClass } from '@sentry/core';
import { NODE_VERSION } from '../../nodeVersion.js';
import { localVariablesAsync } from './local-variables-async.js';
import { localVariablesSync } from './local-variables-sync.js';

const INTEGRATION_NAME = 'LocalVariables';

/**
 * Adds local variables to exception frames
 */
const localVariables = (options = {}) => {
  return NODE_VERSION.major < 19 ? localVariablesSync(options) : localVariablesAsync(options);
};

/**
 * Adds local variables to exception frames
 */
// eslint-disable-next-line deprecation/deprecation
const LocalVariables = convertIntegrationFnToClass(INTEGRATION_NAME, localVariables);

export { LocalVariables };
//# sourceMappingURL=index.js.map
