Object.defineProperty(exports, '__esModule', { value: true });

const core = require('@sentry/core');
const index = require('./tracing/index.js');
const client = require('./client.js');
const http = require('./transports/http.js');
const sdk = require('./sdk.js');
const utils = require('@sentry/utils');
const utils$1 = require('./utils.js');
const module$1 = require('./module.js');
const legacy = require('./integrations/anr/legacy.js');
const handlers = require('./handlers.js');
const index$2 = require('./integrations/index.js');
const integrations = require('./tracing/integrations.js');
const index$1 = require('./integrations/hapi/index.js');
const cron$1 = require('./cron/cron.js');
const nodeCron = require('./cron/node-cron.js');

const INTEGRATIONS = {
  ...core.Integrations,
  // This typecast is somehow needed for now, probably because of the convertIntegrationFnToClass TS shenanigans
  // This is OK for now but should be resolved in v8 when we just pass the functional integrations directly
  ...(index$2

),
  ...integrations,
};

/** Methods to instrument cron libraries for Sentry check-ins */
const cron = {
  instrumentCron: cron$1.instrumentCron,
  instrumentNodeCron: nodeCron.instrumentNodeCron,
};

exports.Hub = core.Hub;
exports.SDK_VERSION = core.SDK_VERSION;
exports.Scope = core.Scope;
exports.addBreadcrumb = core.addBreadcrumb;
exports.addEventProcessor = core.addEventProcessor;
exports.addGlobalEventProcessor = core.addGlobalEventProcessor;
exports.addIntegration = core.addIntegration;
exports.captureCheckIn = core.captureCheckIn;
exports.captureEvent = core.captureEvent;
exports.captureException = core.captureException;
exports.captureMessage = core.captureMessage;
exports.close = core.close;
exports.configureScope = core.configureScope;
exports.continueTrace = core.continueTrace;
exports.createTransport = core.createTransport;
exports.extractTraceparentData = core.extractTraceparentData;
exports.flush = core.flush;
exports.getActiveSpan = core.getActiveSpan;
exports.getActiveTransaction = core.getActiveTransaction;
exports.getClient = core.getClient;
exports.getCurrentHub = core.getCurrentHub;
exports.getCurrentScope = core.getCurrentScope;
exports.getGlobalScope = core.getGlobalScope;
exports.getHubFromCarrier = core.getHubFromCarrier;
exports.getIsolationScope = core.getIsolationScope;
exports.lastEventId = core.lastEventId;
exports.makeMain = core.makeMain;
exports.metrics = core.metrics;
exports.runWithAsyncContext = core.runWithAsyncContext;
exports.setContext = core.setContext;
exports.setExtra = core.setExtra;
exports.setExtras = core.setExtras;
exports.setMeasurement = core.setMeasurement;
exports.setTag = core.setTag;
exports.setTags = core.setTags;
exports.setUser = core.setUser;
exports.spanStatusfromHttpCode = core.spanStatusfromHttpCode;
exports.startActiveSpan = core.startActiveSpan;
exports.startInactiveSpan = core.startInactiveSpan;
exports.startSpan = core.startSpan;
exports.startSpanManual = core.startSpanManual;
exports.startTransaction = core.startTransaction;
exports.trace = core.trace;
exports.withMonitor = core.withMonitor;
exports.withScope = core.withScope;
exports.autoDiscoverNodePerformanceMonitoringIntegrations = index.autoDiscoverNodePerformanceMonitoringIntegrations;
exports.NodeClient = client.NodeClient;
exports.makeNodeTransport = http.makeNodeTransport;
exports.defaultIntegrations = sdk.defaultIntegrations;
exports.defaultStackParser = sdk.defaultStackParser;
exports.getSentryRelease = sdk.getSentryRelease;
exports.init = sdk.init;
exports.DEFAULT_USER_INCLUDES = utils.DEFAULT_USER_INCLUDES;
exports.addRequestDataToEvent = utils.addRequestDataToEvent;
exports.extractRequestData = utils.extractRequestData;
exports.deepReadDirSync = utils$1.deepReadDirSync;
exports.getModuleFromFilename = module$1.getModuleFromFilename;
exports.enableAnrDetection = legacy.enableAnrDetection;
exports.Handlers = handlers;
exports.hapiErrorPlugin = index$1.hapiErrorPlugin;
exports.Integrations = INTEGRATIONS;
exports.cron = cron;
//# sourceMappingURL=index.js.map
