/// <reference types="node" />
import { Attachment } from '@sentry/types';
/**
 * A function that loads minidumps
 * @param deleteAll Whether to just delete all minidumps
 * @param callback A callback to call with the attachment ready to send
 */
export type MinidumpLoader = (deleteAll: boolean, callback: (attachment: Attachment) => void) => Promise<void>;
/**
 * Creates a minidump loader
 * @param getMinidumpPaths A function that returns paths to minidumps
 * @param preProcessFile A function that pre-processes the minidump file
 * @returns A function to fetch minidumps
 */
export declare function createMinidumpLoader(getMinidumpPaths: () => Promise<string[]>, preProcessFile?: (file: Buffer) => Buffer): MinidumpLoader;
/**
 * Gets the minidump loader
 */
export declare function getMinidumpLoader(): MinidumpLoader;
//# sourceMappingURL=minidump-loader.d.ts.map