const node = require('@sentry/node');
const index = require('./integrations/index.js');
const core = require('@sentry/core');
const electronNet = require('./transports/electron-net.js');
const electronOfflineNet = require('./transports/electron-offline-net.js');
const sdk = require('./sdk.js');
const anr = require('./anr.js');
const process = require('../common/process.js');
const mode = require('../common/mode.js');

process.ensureProcess('main');
const Integrations = Object.assign(Object.assign({}, node.Integrations), index);

exports.NodeClient = node.NodeClient;
exports.close = node.close;
exports.flush = node.flush;
exports.lastEventId = node.lastEventId;
exports.Hub = core.Hub;
exports.Scope = core.Scope;
exports.addBreadcrumb = core.addBreadcrumb;
exports.addEventProcessor = core.addEventProcessor;
exports.addGlobalEventProcessor = core.addGlobalEventProcessor;
exports.addIntegration = core.addIntegration;
exports.captureCheckIn = core.captureCheckIn;
exports.captureEvent = core.captureEvent;
exports.captureException = core.captureException;
exports.captureMessage = core.captureMessage;
exports.configureScope = core.configureScope;
exports.continueTrace = core.continueTrace;
exports.createTransport = core.createTransport;
exports.extractTraceparentData = core.extractTraceparentData;
exports.getActiveSpan = core.getActiveSpan;
exports.getActiveTransaction = core.getActiveTransaction;
exports.getClient = core.getClient;
exports.getCurrentHub = core.getCurrentHub;
exports.getCurrentScope = core.getCurrentScope;
exports.getGlobalScope = core.getGlobalScope;
exports.getHubFromCarrier = core.getHubFromCarrier;
exports.getIsolationScope = core.getIsolationScope;
exports.makeMain = core.makeMain;
exports.metrics = core.metrics;
exports.runWithAsyncContext = core.runWithAsyncContext;
exports.setContext = core.setContext;
exports.setExtra = core.setExtra;
exports.setExtras = core.setExtras;
exports.setMeasurement = core.setMeasurement;
exports.setTag = core.setTag;
exports.setTags = core.setTags;
exports.setUser = core.setUser;
exports.spanStatusfromHttpCode = core.spanStatusfromHttpCode;
exports.startActiveSpan = core.startActiveSpan;
exports.startInactiveSpan = core.startInactiveSpan;
exports.startSpan = core.startSpan;
exports.startSpanManual = core.startSpanManual;
exports.startTransaction = core.startTransaction;
exports.trace = core.trace;
exports.withMonitor = core.withMonitor;
exports.withScope = core.withScope;
exports.makeElectronTransport = electronNet.makeElectronTransport;
exports.makeElectronOfflineTransport = electronOfflineNet.makeElectronOfflineTransport;
exports.defaultIntegrations = sdk.defaultIntegrations;
exports.init = sdk.init;
exports.enableMainProcessAnrDetection = anr.enableMainProcessAnrDetection;
Object.defineProperty(exports, 'IPCMode', {
	enumerable: true,
	get: () => mode.IPCMode
});
exports.Integrations = Integrations;
//# sourceMappingURL=index.js.map
