"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.fileExtensionsPlugin = void 0;
/**
 * Plugin which serves configured file extensions as JS.
 */
function fileExtensionsPlugin(config) {
    const { fileExtensions } = config;
    return {
        resolveMimeType(context) {
            if (fileExtensions.some(ext => context.path.endsWith(ext))) {
                return 'js';
            }
        },
    };
}
exports.fileExtensionsPlugin = fileExtensionsPlugin;
//# sourceMappingURL=fileExtensionsPlugin.js.map