"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.browserReloadPlugin = void 0;
const tslib_1 = require("tslib");
const debounce_1 = tslib_1.__importDefault(require("debounce"));
function browserReloadPlugin(cfg) {
    return {
        serverStart({ fileWatcher, messageChannel }) {
            if (messageChannel) {
                function onFileChanged() {
                    console.log('Reloading connected browsers...\n');
                    messageChannel === null || messageChannel === void 0 ? void 0 : messageChannel.sendMessage({ name: 'reload' });
                }
                const onChange = debounce_1.default(onFileChanged, cfg.watchDebounce);
                fileWatcher.addListener('change', onChange);
                fileWatcher.addListener('unlink', onChange);
            }
        },
    };
}
exports.browserReloadPlugin = browserReloadPlugin;
//# sourceMappingURL=browserReloadPlugin.js.map