import chokidar from 'chokidar';
import Koa from 'koa';
import { Server } from 'net';
import { ParsedConfig } from './config';
/**
 * Creates middlewares based on the given configuration. The middlewares can be
 * used by a koa server using `app.use()`:
 */
export declare function createMiddlewares(config: ParsedConfig, fileWatcher?: chokidar.FSWatcher): {
    middlewares: import("koa-compose").Middleware<Koa.ParameterizedContext<Koa.DefaultState, Koa.DefaultContext>>[];
    onServerStarted(app: Koa, server: Server): Promise<void>;
};
