import { StackParser } from '@sentry/types';
import { NodeClient } from './client';
import { Http, Undici } from './integrations';
import { NodeOptions } from './types';
export declare const defaultIntegrations: (Http | (import("@sentry/types").Integration & {
    name: string;
    processEvent(event: import("@sentry/types").Event): import("@sentry/types").Event;
} & {
    setupOnce: (addGlobalEventProcessor?: ((callback: import("@sentry/types").EventProcessor) => void) | undefined, getCurrentHub?: (() => import("@sentry/types").Hub) | undefined) => void;
}) | (import("@sentry/types").Integration & import("@sentry/types").IntegrationFnResult & {
    setupOnce: (addGlobalEventProcessor?: ((callback: import("@sentry/types").EventProcessor) => void) | undefined, getCurrentHub?: (() => import("@sentry/types").Hub) | undefined) => void;
}) | Undici | (import("@sentry/types").Integration & {
    name: string;
    setup(client: import("@sentry/types").Client<import("@sentry/types").ClientOptions<import("@sentry/types").BaseTransportOptions>>): void;
} & {
    setupOnce: (addGlobalEventProcessor?: ((callback: import("@sentry/types").EventProcessor) => void) | undefined, getCurrentHub?: (() => import("@sentry/types").Hub) | undefined) => void;
}) | (import("@sentry/types").Integration & {
    name: string;
    processEvent(event: import("@sentry/types").Event): Promise<import("@sentry/types").Event>;
} & {
    setupOnce: (addGlobalEventProcessor?: ((callback: import("@sentry/types").EventProcessor) => void) | undefined, getCurrentHub?: (() => import("@sentry/types").Hub) | undefined) => void;
}))[];
/**
 * The Sentry Node SDK Client.
 *
 * To use this SDK, call the {@link init} function as early as possible in the
 * main entry module. To set context information or send manual events, use the
 * provided methods.
 *
 * @example
 * ```
 *
 * const { init } = require('@sentry/node');
 *
 * init({
 *   dsn: '__DSN__',
 *   // ...
 * });
 * ```
 *
 * @example
 * ```
 *
 * const { configureScope } = require('@sentry/node');
 * configureScope((scope: Scope) => {
 *   scope.setExtra({ battery: 0.7 });
 *   scope.setTag({ user_mode: 'admin' });
 *   scope.setUser({ id: '4711' });
 * });
 * ```
 *
 * @example
 * ```
 *
 * const { addBreadcrumb } = require('@sentry/node');
 * addBreadcrumb({
 *   message: 'My Breadcrumb',
 *   // ...
 * });
 * ```
 *
 * @example
 * ```
 *
 * const Sentry = require('@sentry/node');
 * Sentry.captureMessage('Hello, world!');
 * Sentry.captureException(new Error('Good bye'));
 * Sentry.captureEvent({
 *   message: 'Manual',
 *   stacktrace: [
 *     // ...
 *   ],
 * });
 * ```
 *
 * @see {@link NodeOptions} for documentation on configuration options.
 */
export declare function init(options?: NodeOptions): void;
/**
 * Function that takes an instance of NodeClient and checks if autoSessionTracking option is enabled for that client
 */
export declare function isAutoSessionTrackingEnabled(client?: NodeClient): boolean;
/**
 * Returns a release dynamically from environment variables.
 */
export declare function getSentryRelease(fallback?: string): string | undefined;
/** Node.js stack parser */
export declare const defaultStackParser: StackParser;
//# sourceMappingURL=sdk.d.ts.map
