Object.defineProperty(exports, '__esModule', { value: true });

const core = require('@sentry/core');
const nodeVersion = require('../../nodeVersion.js');
const localVariablesAsync = require('./local-variables-async.js');
const localVariablesSync = require('./local-variables-sync.js');

const INTEGRATION_NAME = 'LocalVariables';

/**
 * Adds local variables to exception frames
 */
const localVariables = (options = {}) => {
  return nodeVersion.NODE_VERSION.major < 19 ? localVariablesSync.localVariablesSync(options) : localVariablesAsync.localVariablesAsync(options);
};

/**
 * Adds local variables to exception frames
 */
// eslint-disable-next-line deprecation/deprecation
const LocalVariables = core.convertIntegrationFnToClass(INTEGRATION_NAME, localVariables);

exports.LocalVariables = LocalVariables;
//# sourceMappingURL=index.js.map
