const core = require('@sentry/core');
const metrics = require('../metrics.js');

const INTEGRATION_NAME = 'MetricsAggregator';
const metricsAggregatorIntegration = () => {
    return {
        name: INTEGRATION_NAME,
        setup(client) {
            client.metricsAggregator = new metrics.ElectronRendererMetricsAggregator();
        },
    };
};
/**
 * Enables Sentry metrics monitoring.
 *
 * @experimental This API is experimental and might having breaking changes in the future.
 */
// eslint-disable-next-line deprecation/deprecation
const MetricsAggregator = core.convertIntegrationFnToClass(INTEGRATION_NAME, metricsAggregatorIntegration);

exports.MetricsAggregator = MetricsAggregator;
//# sourceMappingURL=metrics-aggregator.js.map
