import { Transport, TransportRequest } from '@sentry/types';
import { ElectronNetTransportOptions } from './electron-net';
type BeforeSendResponse = 'send' | 'queue' | 'drop';
export interface ElectronOfflineTransportOptions extends ElectronNetTransportOptions {
    /**
     * The maximum number of days to keep an event in the queue.
     */
    maxQueueAgeDays?: number;
    /**
     * The maximum number of events to keep in the queue.
     */
    maxQueueCount?: number;
    /**
     * Called every time the number of requests in the queue changes.
     */
    queuedLengthChanged?: (length: number) => void;
    /**
     * Called before attempting to send an event to Sentry.
     *
     * Return 'send' to attempt to send the event.
     * Return 'queue' to queue and persist the event for sending later.
     * Return 'drop' to drop the event.
     */
    beforeSend?: (request: TransportRequest) => BeforeSendResponse | Promise<BeforeSendResponse>;
}
/**
 * Creates a Transport that uses Electrons net module to send events to Sentry. When they fail to send they are
 * persisted to disk and sent later
 */
export declare function makeElectronOfflineTransport(options: ElectronOfflineTransportOptions): Transport;
export {};
//# sourceMappingURL=electron-offline-net.d.ts.map