const tslib = require('tslib');
const core = require('@sentry/core');
const electron = require('electron');
const context = require('../context.js');
const normalize = require('../../common/normalize.js');
const merge = require('../../common/merge.js');

const INTEGRATION_NAME = 'MainContext';
const mainContext = () => {
    return {
        name: INTEGRATION_NAME,
        processEvent(event, _, client) {
            return tslib.__awaiter(this, void 0, void 0, function* () {
                const clientOptions = client.getOptions();
                const normalized = normalize.normalizeEvent(event, electron.app.getAppPath());
                const defaults = yield context.getEventDefaults(clientOptions.release, clientOptions.environment);
                return merge.mergeEvents(defaults, normalized);
            });
        },
    };
};
/** Adds Electron context to events and normalises paths. */
// eslint-disable-next-line deprecation/deprecation
const MainContext = core.convertIntegrationFnToClass(INTEGRATION_NAME, mainContext);

exports.MainContext = MainContext;
//# sourceMappingURL=main-context.js.map
