/// <reference types="node" />
import { BrowserWindow, NativeImage, WebContents } from 'electron';
import { Optional } from '../common/types';
export declare const ELECTRON_MAJOR_VERSION: number;
/** Returns if the app is packaged. Copied from Electron to support < v3 */
export declare const isPackaged: boolean;
/** A promise that is resolved when the app is ready */
export declare const whenAppReady: Promise<void>;
/**
 * Electron >= 5 support full protocol API
 */
export declare function supportsFullProtocol(): boolean;
export declare const EXIT_REASONS: readonly ["clean-exit", "abnormal-exit", "killed", "crashed", "oom", "launch-failed", "integrity-failure"];
export type ExitReason = (typeof EXIT_REASONS)[number];
export declare const CRASH_REASONS: Readonly<ExitReason[]>;
/** Same as the Electron interface but with optional exitCode */
type RenderProcessGoneDetails = Optional<Electron.RenderProcessGoneDetails, 'exitCode'>;
/**
 * Implements 'render-process-gone' event across Electron versions
 */
export declare function onRendererProcessGone(reasons: Readonly<ExitReason[]>, callback: (contents: WebContents, details: RenderProcessGoneDetails) => void): void;
type Details = Optional<Electron.Details, 'exitCode'>;
/**
 * Calls callback on child process crash if Electron version support 'child-process-gone' event
 */
export declare function onChildProcessGone(reasons: Readonly<ExitReason[]>, callback: (details: Details) => void): void;
/** Calls callback when BrowserWindow are created */
export declare function onBrowserWindowCreated(callback: (window: BrowserWindow) => void): void;
/** Calls callback when WebContents are created */
export declare function onWebContentsCreated(callback: (window: WebContents) => void): void;
/**
 * Electron < 9 requires `crashReporter.start()` in the renderer
 */
export declare function rendererRequiresCrashReporterStart(): boolean;
/** Is using Crashpad */
export declare function usesCrashpad(): boolean;
/**
 * Electron >= 9 uses `app.getPath('crashDumps')` rather than
 * `crashReporter.getCrashesDirectory()`
 */
export declare function getCrashesDirectory(): string;
/** Captures a NativeImage from a BrowserWindow */
export declare function capturePage(window: BrowserWindow): Promise<NativeImage>;
interface InternalRequest {
    windowId?: string;
    url: string;
    body?: Buffer;
}
/**
 * Registers a custom protocol to receive events from the renderer
 *
 * Uses `protocol.handle` if available, otherwise falls back to `protocol.registerStringProtocol`
 */
export declare function registerProtocol(protocol: Electron.Protocol, scheme: string, callback: (request: InternalRequest) => void): void;
export {};
//# sourceMappingURL=electron-normalize.d.ts.map