import { __awaiter } from 'tslib';
import { convertIntegrationFnToClass } from '@sentry/core';
import { app } from 'electron';
import { getEventDefaults } from '../context.js';
import { normalizeEvent } from '../../common/normalize.js';
import { mergeEvents } from '../../common/merge.js';

const INTEGRATION_NAME = 'MainContext';
const mainContext = () => {
    return {
        name: INTEGRATION_NAME,
        processEvent(event, _, client) {
            return __awaiter(this, void 0, void 0, function* () {
                const clientOptions = client.getOptions();
                const normalized = normalizeEvent(event, app.getAppPath());
                const defaults = yield getEventDefaults(clientOptions.release, clientOptions.environment);
                return mergeEvents(defaults, normalized);
            });
        },
    };
};
/** Adds Electron context to events and normalises paths. */
// eslint-disable-next-line deprecation/deprecation
const MainContext = convertIntegrationFnToClass(INTEGRATION_NAME, mainContext);

export { MainContext };
//# sourceMappingURL=main-context.js.map
