/**
@license
Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/
import {Polymer} from '@polymer/polymer/lib/legacy/polymer-fn.js';

import {html} from '@polymer/polymer/lib/utils/html-tag.js';
Polymer({
  _template: html`
    <style>

      :host {
        display: block;
        background-color: white;
        height: 500px;
        overflow: hidden;
        position: relative;
        visibility: hidden;
        -webkit-tap-highlight-color: rgba(0, 0, 0, 0);
      }

      .price {
        position: absolute;
        right: 0;
        top: 0;
        background-color: #fee0e0;
        height: 50px;
        line-height: 50px;
        font-size: 20px;
        padding-left: 30px;
        padding-right: 30px;
      }

      .pic {
        position: relative;
        width: 40%;
      }

      .pic img {
        width: 100%;
      }

      .detail {
        position: absolute;
        top: 0;
        right: 20px;
        width: 40em;
        max-width: 60%;
      }

      h1 {
        font-family: 'Abril Fatface', cursive;
        font-size: 6em;
        font-weight: 300;
        color: #0a3142;
        margin: 0;
        line-height: 1em;
        margin-top: 60px;
        margin-bottom: 60px;
        display: block;
        text-decoration: none;
        border-bottom: 1px solid transparent;
      }

      .desc {
        position: relative;
        max-width: 300px;
        float: right;
      }

      .desc::before {
        background-color: #31f0ef;
        content: "";
        height: 6px;
        left: 0;
        line-height: 21px;
        position: absolute;
        top: -6px;
        width: 100px;
      }

      .desc p {
        margin-bottom: 30px;
        font-size: 14px;
        color: #333;
        font-weight: 300;
      }

      .desc .author {
        font-size: 11px;
        line-height: 30px;
        color: #000;
      }

      .desc .author img {
        width: 30px;
        height: 30px;
        border-radius: 50% 50%;
        display: inline-block;
        vertical-align: middle;
        margin-right: 10px;
        border: 2px solid white;
      }

      @media (max-width: 1200px) {
        :host {
          height: 420px;
        }

        h1 {
          font-size: 4em;
          margin-top: 60px;
          margin-bottom: 60px;
        }
      }

      @media (max-width: 640px) {
        h1 {
          font-size: 3em;
          margin-top: 60px;
          margin-bottom: 60px;
        }
      }

      @media (max-width: 400px) {
        :host {
          height: 260px;
        }

        h1 {
          font-size: 2em;
          margin-top: 40px;
          margin-bottom: 40px;
        }

        .detail {
          width: 60%;
          right: 0;
        }

        .desc p {
          font-size: 11px;
        }

        .price {
          height: 30px;
          line-height: 30px;
          padding-left: 20px;
          padding-right: 20px;
          font-size: 15px;
        }

        .desc::before {
          height: 3px;
          top: -3px;
        }
      }

    </style>

    <div class="price">[[item.price]]</div>
    <div class="pic">
      <img id="img">
    </div>
    <div class="detail">
      <h1>[[item.title]]</h1>
      <div class="desc">
        <p>[[item.quote]]</p>
        <div class="author">
          <img src="[[item.storeAvatarUrl]]">
          [[item.storeName]]
        </div>
      </div>
    </div>
`,

  is: 'shrine-featured-item',

  properties: {

    item: {type: Object, observer: '_itemChanged'}

  },

  _itemChanged: function(item) {
    this.style.visibility = item && item.title ? 'visible' : 'hidden';
    this.$.img.src = '';
    this.$.img.src = item ? item.imageUrl : '';
  }
});
