const node = require('@sentry/node');
const utils = require('@sentry/utils');
const electron = require('electron');

/** Parses the module name form a filename */
function getModuleFromFilename(filename) {
    if (!filename) {
        return;
    }
    const normalizedFilename = utils.normalizeUrlToBase(filename, electron.app.getAppPath());
    return node.getModuleFromFilename(normalizedFilename);
}
// node.js stack parser but filename normalized before parsing the module
const defaultStackParser = utils.createStackParser(utils.nodeStackLineParser(getModuleFromFilename));

exports.defaultStackParser = defaultStackParser;
//# sourceMappingURL=stack-parse.js.map
