import Prism from 'prismjs';
import parse from 'rehype-parse';
import unified from 'unified';
import { visit } from 'unist-util-visit';
import { select } from 'unist-util-select';
const getLang = (node) => {
    var _a, _b;
    const lang = ((_b = (_a = node.properties) === null || _a === void 0 ? void 0 : _a.className) === null || _b === void 0 ? void 0 : _b[0]) || '';
    return lang.replace(/^language-/, '');
};
const visitor = (preNode) => {
    const codeNode = select('[tagName=code]', preNode);
    if (!codeNode)
        return;
    const lang = getLang(codeNode);
    if (!lang || !Prism.languages[lang])
        return;
    const textNode = select('text', codeNode);
    if (!textNode)
        return;
    const className = `language-${lang}`;
    const html = Prism.highlight(textNode.value, Prism.languages[lang], lang);
    const tree = unified()
        .use(parse, { fragment: true })
        .parse(html);
    if (!preNode.properties)
        preNode.properties = {};
    if (!preNode.properties.className)
        preNode.properties.className = [];
    if (typeof preNode.properties.className === 'string')
        preNode.properties.className = [preNode.properties.className];
    if (typeof preNode.properties.className === 'number')
        preNode.properties.className = [preNode.properties.className];
    if (typeof preNode.properties.className === 'boolean')
        preNode.properties.className = [];
    preNode.properties.className = [...preNode.properties.className, className];
    codeNode.children = tree.children;
};
const selector = (node) => node.tagName === 'pre';
const rehypePrism = (options) => {
    if (options && options.plugins) {
        for (const plugin of options.plugins) {
            require(`prismjs/plugins/line-numbers/prism-${plugin}`);
        }
    }
    return (tree) => visit(tree, selector, visitor);
};
export default rehypePrism;
