var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __markAsModule = (target) => __defProp(target, "__esModule", { value: true });
var __export = (target, all) => {
  __markAsModule(target);
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};

// index.js
__export(exports, {
  addPlugin: () => addPlugin,
  adjustPluginOptions: () => adjustPluginOptions,
  applyPlugins: () => applyPlugins,
  executeSetupFunctions: () => executeSetupFunctions,
  removePlugin: () => removePlugin
});

// src/addPlugin.js
function addPlugin(plugin, options = {}, { how = "after", location = "bottom" } = {}) {
  const addPluginFn = (plugins) => {
    if (plugins === void 0) {
      plugins = [];
    }
    const usePlugin = addPluginFn.wrapPlugin ? addPluginFn.wrapPlugin(plugin) : plugin;
    if (plugins.findIndex((pluginObj) => pluginObj.plugin === plugin) === -1) {
      let index = -1;
      let _how = how;
      switch (location) {
        case "top":
          index = 0;
          _how = "fixed";
          break;
        case "bottom":
          index = plugins.length;
          _how = "fixed";
          break;
        default:
          index = plugins.findIndex((pluginObj) => pluginObj.plugin === location);
      }
      if (index < 0) {
        const errorName = location === "top" || location === "bottom" ? location : location.name;
        throw new Error(`Could not find a plugin with the name "${errorName}" to insert "${plugin.name}" ${how} it.`);
      }
      if (_how === "after") {
        index += 1;
      }
      plugins.splice(index, 0, {
        plugin: usePlugin,
        options
      });
    }
    return plugins;
  };
  return addPluginFn;
}

// src/removePlugin.js
function removePlugin(plugin) {
  const removePluginFn = (plugins) => {
    const index = plugins.findIndex((pluginObj) => pluginObj.plugin === plugin);
    if (index === -1) {
      throw new Error(`Could not find a plugin with the name "${plugin.name}" to remove.`);
    }
    plugins.splice(index, 1);
    return plugins;
  };
  return removePluginFn;
}

// src/adjustPluginOptions.js
function isObject(obj) {
  return typeof obj === "object" && !!obj && !Array.isArray(obj);
}
function isFunction(x) {
  return typeof x === "function";
}
function adjustPluginOptions(plugin, mergeOptions) {
  const adjustPluginOptionsFn = (plugins) => {
    const index = plugins.findIndex((pluginObj) => pluginObj.plugin === plugin);
    if (index === -1) {
      throw new Error(`Could not find a plugin with the name "${plugin.name}" to adjust it's options with:
${JSON.stringify(mergeOptions, null, 2)}`);
    }
    if (isFunction(mergeOptions)) {
      plugins[index].options = mergeOptions(plugins[index].options);
    } else if (isObject(plugins[index].options)) {
      plugins[index].options = __spreadValues(__spreadValues({}, plugins[index].options), mergeOptions);
    } else {
      plugins[index].options = mergeOptions;
    }
    return plugins;
  };
  return adjustPluginOptionsFn;
}

// src/executeSetupFunctions.js
function executeSetupFunctions(setupFunctions, metaPlugins = []) {
  let _metaPlugins = [...metaPlugins];
  if (Array.isArray(setupFunctions)) {
    for (const setupFn of setupFunctions) {
      _metaPlugins = setupFn(_metaPlugins);
    }
  }
  return _metaPlugins;
}

// src/applyPlugins.js
function isClass(func) {
  if (typeof func === "function" && func.prototype) {
    try {
      func.arguments && func.caller;
    } catch (error) {
      return true;
    }
  }
  return false;
}
function applyPlugins(config, defaultPlugins = []) {
  if (config.plugins) {
    delete config.setupPlugins;
    return config;
  }
  const _metaPlugins = executeSetupFunctions(config.setupPlugins, [...defaultPlugins]);
  const plugins = _metaPlugins.map((pluginObj) => {
    if (isClass(pluginObj.plugin)) {
      const ClassPlugin = pluginObj.plugin;
      return pluginObj.options ? new ClassPlugin(pluginObj.options) : new ClassPlugin();
    } else {
      const fnPlugin = pluginObj.plugin;
      return pluginObj.options ? fnPlugin(pluginObj.options) : fnPlugin();
    }
  });
  config.plugins = plugins;
  delete config.setupPlugins;
  return config;
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  addPlugin,
  adjustPluginOptions,
  applyPlugins,
  executeSetupFunctions,
  removePlugin
});
