"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.STANDARD_TARGET_NAME_MAPPING = exports.AstNodeTypes = void 0;

/* eslint import/prefer-default-export: off */
// Maps an ID to the full name user will see
// E.g. during error, user will see full name instead of ID
const STANDARD_TARGET_NAME_MAPPING = {
  chrome: "Chrome",
  firefox: "Firefox",
  safari: "Safari",
  ios_saf: "iOS Safari",
  ie: "IE",
  ie_mob: "IE Mobile",
  edge: "Edge",
  baidu: "Baidu",
  electron: "Electron",
  blackberry_browser: "Blackberry Browser",
  edge_mobile: "Edge Mobile",
  and_uc: "Android UC Browser",
  and_chrome: "Android Chrome",
  and_firefox: "Android Firefox",
  and_webview: "Android Webview",
  and_samsung: "Samsung Browser",
  and_opera: "Opera Android",
  opera: "Opera",
  opera_mini: "Opera Mini",
  opera_mobile: "Opera Mobile",
  node: "Node.js",
  kaios: "KaiOS"
};
exports.STANDARD_TARGET_NAME_MAPPING = STANDARD_TARGET_NAME_MAPPING;
let AstNodeTypes;
exports.AstNodeTypes = AstNodeTypes;

(function (AstNodeTypes) {
  AstNodeTypes["MemberExpression"] = "MemberExpression";
  AstNodeTypes["CallExpression"] = "CallExpression";
  AstNodeTypes["NewExpression"] = "NewExpression";
})(AstNodeTypes || (exports.AstNodeTypes = AstNodeTypes = {}));
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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