"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.runTests = void 0;
/* eslint-disable no-async-promise-executor, no-inner-declarations */
const portfinder_1 = require("portfinder");
const path_1 = __importDefault(require("path"));
const index_1 = require("./index");
const TestSessionStatus_1 = require("./test-session/TestSessionStatus");
const logger = Object.assign(Object.assign({}, console), { debug() {
        //
    },
    logSyntaxError(error) {
        console.error(error);
    } });
const secondMs = 1000;
const minuteMs = secondMs * 60;
const defaultBaseConfig = {
    watch: false,
    rootDir: path_1.default.join(__dirname, '..', '..', '..'),
    testFramework: {
        path: require.resolve('@web/test-runner-mocha/dist/autorun.js'),
    },
    protocol: 'http:',
    hostname: 'localhost',
    reporters: [],
    concurrentBrowsers: 2,
    concurrency: 10,
    browserStartTimeout: minuteMs / 2,
    testsStartTimeout: secondMs * 20,
    testsFinishTimeout: minuteMs * 2,
    browserLogs: true,
    logger,
};
async function runTests(config, groupConfigs, { allowFailure = false, reportErrors = true, } = {}) {
    return new Promise(async (resolve, reject) => {
        const port = await (0, portfinder_1.getPortPromise)({ port: 9000 + Math.floor(Math.random() * 1000) });
        const finalConfig = Object.assign(Object.assign(Object.assign({ port }, defaultBaseConfig), config), { testFramework: Object.assign(Object.assign({}, defaultBaseConfig.testFramework), config.testFramework) });
        const runner = new index_1.TestRunner(finalConfig, groupConfigs);
        let finished = false;
        runner.on('test-run-finished', ({ testRun, testCoverage }) => {
            var _a;
            for (const reporter of finalConfig.reporters) {
                (_a = reporter.onTestRunFinished) === null || _a === void 0 ? void 0 : _a.call(reporter, {
                    testRun,
                    sessions: Array.from(runner.sessions.all()),
                    testCoverage,
                    focusedTestFile: runner.focusedTestFile,
                });
            }
        });
        runner.on('finished', async () => {
            var _a;
            for (const reporter of finalConfig.reporters) {
                await ((_a = reporter.stop) === null || _a === void 0 ? void 0 : _a.call(reporter, {
                    sessions: Array.from(runner.sessions.all()),
                    focusedTestFile: runner.focusedTestFile,
                }));
            }
            finished = true;
            runner.stop();
        });
        setTimeout(() => {
            finished = true;
            if (!finished) {
                runner.stop();
            }
        }, 20000);
        runner.on('stopped', passed => {
            var _a;
            const sessions = Array.from(runner.sessions.all());
            if (reportErrors) {
                for (const session of sessions) {
                    if (!session.passed || session.request404s.length > 0) {
                        console.log('');
                        console.log('Failed test file:', session.browser.name, path_1.default.relative(process.cwd(), session.testFile));
                    }
                    for (const log of session.logs) {
                        if (log.length !== 0) {
                            console.log('[Browser log]', ...log.map(l => (l.__WTR_BROWSER_ERROR__ ? l.stack : l)));
                        }
                    }
                    for (const request404 of session.request404s) {
                        console.log('[Request 404]', request404);
                    }
                    if (!session.passed) {
                        for (const error of session.errors) {
                            console.error((_a = error.stack) !== null && _a !== void 0 ? _a : error.message);
                        }
                        function iterateTests(tests) {
                            var _a, _b, _c;
                            for (const test of tests) {
                                if (!test.passed) {
                                    console.log(test.name, (_b = (_a = test.error) === null || _a === void 0 ? void 0 : _a.stack) !== null && _b !== void 0 ? _b : (_c = test.error) === null || _c === void 0 ? void 0 : _c.message);
                                }
                            }
                        }
                        function iterateSuite(suite) {
                            iterateTests(suite.tests);
                            for (const s of suite.suites) {
                                iterateSuite(s);
                            }
                        }
                        if (session.testResults) {
                            iterateSuite(session.testResults);
                        }
                    }
                }
            }
            if (!sessions.every(s => s.status === TestSessionStatus_1.SESSION_STATUS.FINISHED)) {
                reject(new Error('Tests did not finish'));
                return;
            }
            if (allowFailure || passed) {
                resolve({ runner, sessions });
            }
            else {
                reject(new Error('Test run did not pass'));
            }
        });
        runner.start();
    });
}
exports.runTests = runTests;
//# sourceMappingURL=test-helpers.js.map