"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseBrowserResult = void 0;
const parseBrowserErrors_1 = require("./parseBrowserErrors");
const parseBrowserLogs_1 = require("./parseBrowserLogs");
function createMapStackLocation(smFn, userAgent) {
    return async function mapStackLocation(originalLoc) {
        const mappedLoc = await smFn(originalLoc, userAgent);
        return mappedLoc ? mappedLoc : originalLoc;
    };
}
async function parseBrowserResult(config, mapBrowserUrl, sourceMapFunction, userAgent, result) {
    const mapStackLocation = createMapStackLocation(sourceMapFunction, userAgent);
    await Promise.all([
        (0, parseBrowserLogs_1.parseBrowserLogs)(config, mapBrowserUrl, mapStackLocation, result).catch(error => {
            console.error(error);
        }),
        (0, parseBrowserErrors_1.parseSessionErrors)(config, mapBrowserUrl, mapStackLocation, result).catch(error => {
            console.error(error);
        }),
        (0, parseBrowserErrors_1.parseTestResults)(config, mapBrowserUrl, mapStackLocation, result).catch(error => {
            console.error(error);
        }),
    ]);
    return result;
}
exports.parseBrowserResult = parseBrowserResult;
//# sourceMappingURL=parseBrowserResult.js.map