"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createSessionUrl = exports.toBrowserPath = void 0;
const path_1 = __importDefault(require("path"));
const constants_1 = require("../utils/constants");
const toBrowserPathRegExp = new RegExp(path_1.default.sep === '\\' ? '\\\\' : path_1.default.sep, 'g');
function toBrowserPath(filePath) {
    return filePath.replace(toBrowserPathRegExp, '/');
}
exports.toBrowserPath = toBrowserPath;
function createSessionUrl(config, session) {
    let browserPath;
    if (session.testFile.endsWith('.html')) {
        const resolvedPath = path_1.default.resolve(session.testFile);
        const relativePath = path_1.default.relative(config.rootDir, resolvedPath);
        browserPath = `/${toBrowserPath(relativePath)}`;
    }
    else {
        browserPath = '/';
    }
    const params = `?${constants_1.PARAM_SESSION_ID}=${session.id}`;
    return `${config.protocol}//${config.hostname}:${config.port}${browserPath}${params}`;
}
exports.createSessionUrl = createSessionUrl;
//# sourceMappingURL=createSessionUrl.js.map