import { TestRunnerCoreConfig } from '../config/TestRunnerCoreConfig';
import { TestSession } from '../test-session/TestSession';
import { TestCoverage } from '../coverage/getTestCoverage';
import { TestSessionManager } from '../test-session/TestSessionManager';
import { EventEmitter } from '../utils/EventEmitter';
import { BrowserLauncher } from '../browser-launcher/BrowserLauncher';
import { TestRunnerGroupConfig } from '../config/TestRunnerGroupConfig';
interface EventMap {
    'test-run-started': {
        testRun: number;
    };
    'test-run-finished': {
        testRun: number;
        testCoverage?: TestCoverage;
    };
    finished: boolean;
    stopped: boolean;
}
export declare class TestRunner extends EventEmitter<EventMap> {
    config: TestRunnerCoreConfig;
    sessions: TestSessionManager;
    testFiles: string[];
    browsers: BrowserLauncher[];
    browserNames: string[];
    startTime: number;
    testRun: number;
    started: boolean;
    stopped: boolean;
    running: boolean;
    passed: boolean;
    focusedTestFile: string | undefined;
    private scheduler;
    private server;
    private pendingSessions;
    constructor(config: TestRunnerCoreConfig, groupConfigs?: TestRunnerGroupConfig[]);
    start(): Promise<void>;
    runTests(sessions: Iterable<TestSession>): Promise<void>;
    stop(error?: any): Promise<void>;
    startDebugBrowser(testFile: string): void;
    private onSessionFinished;
}
export {};
//# sourceMappingURL=TestRunner.d.ts.map