"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.shouldInjectLoader = exports.createError = void 0;
const polyfills_loader_1 = require("@web/polyfills-loader");
const PLUGIN = '[rollup-plugin-polyfills-loader]';
function createError(msg) {
    return new Error(`${PLUGIN} ${msg}`);
}
exports.createError = createError;
function shouldInjectLoader(config) {
    if (config.modern.files.some((f) => f.type !== polyfills_loader_1.fileTypes.MODULE)) {
        return true;
    }
    if (config.legacy && config.legacy.length > 0) {
        return true;
    }
    if (config.polyfills && config.polyfills.custom && config.polyfills.custom.length > 0) {
        return true;
    }
    return !!(config.polyfills &&
        Object.entries(config.polyfills).some(([k, v]) => !['hash', 'custom'].includes(k) && v !== false));
}
exports.shouldInjectLoader = shouldInjectLoader;
//# sourceMappingURL=utils.js.map