"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.polyfillsLoader = void 0;
const polyfills_loader_1 = require("@web/polyfills-loader");
const path_1 = __importDefault(require("path"));
const utils_1 = require("./utils");
const createPolyfillsLoaderConfig_1 = require("./createPolyfillsLoaderConfig");
function polyfillsLoader(pluginOptions = {}) {
    let generatedFiles;
    return {
        name: '@web/rollup-plugin-polyfills-loader',
        buildStart(options) {
            generatedFiles = undefined;
            if (!options.plugins) {
                throw utils_1.createError('Could not find any installed plugins');
            }
            const htmlPlugins = options.plugins.filter(p => p.name === '@web/rollup-plugin-html');
            const [htmlPlugin] = htmlPlugins;
            if (!htmlPlugin) {
                throw utils_1.createError('Could not find any instance of @web/rollup-plugin-html in rollup build.');
            }
            htmlPlugin.api.disableDefaultInject();
            htmlPlugin.api.addHtmlTransformer(async (html, { bundle, bundles, htmlFileName }) => {
                var _a, _b, _c;
                const config = createPolyfillsLoaderConfig_1.createPolyfillsLoaderConfig(pluginOptions, bundle, bundles);
                const relativePathToPolyfills = path_1.default.relative(path_1.default.dirname(htmlFileName), path_1.default.dirname(pluginOptions.polyfillsDir || './polyfills'));
                let htmlString = html;
                if (utils_1.shouldInjectLoader(config)) {
                    const result = await polyfills_loader_1.injectPolyfillsLoader(html, Object.assign(Object.assign({}, config), { relativePathToPolyfills }));
                    htmlString = result.htmlString;
                    generatedFiles = result.polyfillFiles;
                }
                else {
                    // we don't need to inject a polyfills loader, so we just inject the scripts directly
                    const scripts = config
                        .modern.files.map((f) => {
                        let attributes = '';
                        if (f.attributes && f.attributes.length > 0) {
                            attributes = ' ';
                            attributes += f.attributes
                                .map(attribute => `${attribute.name}="${attribute.value}"`)
                                .join(' ');
                        }
                        return `<script type="module" src="${f.path}"${attributes}></script>\n`;
                    })
                        .join('');
                    htmlString = htmlString.replace('</body>', `\n${scripts}\n</body>`);
                }
                // preload all entrypoints as well as their direct dependencies
                const { entrypoints } = pluginOptions.legacyOutput && pluginOptions.modernOutput
                    ? bundles[pluginOptions.modernOutput.name]
                    : bundle;
                let preloaded = [];
                for (const entrypoint of entrypoints) {
                    preloaded.push(entrypoint.importPath);
                    // js files (incl. chunks) will always be in the root directory
                    const pathToRoot = path_1.default.posix.dirname(entrypoint.importPath);
                    for (const chunkPath of entrypoint.chunk.imports) {
                        preloaded.push(path_1.default.posix.join(pathToRoot, chunkPath));
                    }
                }
                preloaded = [...new Set(preloaded)];
                const type = (_b = (_a = pluginOptions.modernOutput) === null || _a === void 0 ? void 0 : _a.type) !== null && _b !== void 0 ? _b : createPolyfillsLoaderConfig_1.formatToFileType((_c = bundle === null || bundle === void 0 ? void 0 : bundle.options.format) !== null && _c !== void 0 ? _c : 'esm');
                const crossorigin = type === polyfills_loader_1.fileTypes.MODULE ? ' crossorigin="anonymous"' : '';
                const shim = type === polyfills_loader_1.fileTypes.MODULESHIM;
                const rel = `${shim ? 'module' : ''}preload${shim ? '-shim' : ''}`;
                const as = shim ? '' : ' as="script"';
                return htmlString.replace('</head>', `\n${preloaded
                    .map(i => `<link rel="${rel}" href="${i}"${as}${crossorigin} />\n`)
                    .join('')}</head>`);
            });
        },
        generateBundle(_, bundle) {
            if (generatedFiles) {
                for (const file of generatedFiles) {
                    // if the polyfills loader is used multiple times, this polyfill might already be output
                    // so we guard against that. polyfills are already hashed, so there is no need to worry
                    // about clashing
                    if (!(file.path in bundle)) {
                        this.emitFile({
                            type: 'asset',
                            name: file.path,
                            fileName: file.path,
                            source: file.content,
                        });
                    }
                }
            }
        },
    };
}
exports.polyfillsLoader = polyfillsLoader;
//# sourceMappingURL=rollupPluginPolyfillsLoader.js.map