"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createPolyfillsLoaderConfig = exports.formatToFileType = void 0;
const polyfills_loader_1 = require("@web/polyfills-loader");
const utils_1 = require("./utils");
function formatToFileType(format) {
    switch (format) {
        case 'es':
        case 'esm':
        case 'module':
            return polyfills_loader_1.fileTypes.MODULE;
        case 'system':
            return polyfills_loader_1.fileTypes.SYSTEMJS;
        default:
            return polyfills_loader_1.fileTypes.SCRIPT;
    }
}
exports.formatToFileType = formatToFileType;
function bundleNotFoundError(name) {
    return utils_1.createError(`Could not find any @web/rollup-plugin-html output named ${name}.`);
}
function createEntrypoints(bundle, filetype) {
    if (!bundle.options.format) {
        throw utils_1.createError('An output format must be configured');
    }
    const type = filetype || formatToFileType(bundle.options.format);
    const files = bundle.entrypoints.map(e => ({
        type,
        path: e.importPath,
        attributes: e.attributes,
    }));
    return { files };
}
function createLegacyEntrypoints(bundle, test, fileType) {
    return Object.assign(Object.assign({}, createEntrypoints(bundle, fileType)), { test });
}
function createPolyfillsLoaderConfig(pluginOptions, bundle, bundles) {
    const { modernOutput, legacyOutput, polyfills } = pluginOptions;
    let modern;
    let legacy;
    // @web/rollup-plugin-html outputs `bundle` when there is a single output,
    // otherwise it outputs `bundles`
    if (bundle) {
        if (modernOutput && legacyOutput) {
            throw utils_1.createError('Options modernOutput and legacyOutput was set, but @web/rollup-plugin-html' +
                ` did not output multiple builds. Make sure you use html.api.addOutput('my-output') for each rollup output.`);
        }
        modern = createEntrypoints(bundle, modernOutput === null || modernOutput === void 0 ? void 0 : modernOutput.type);
    }
    else {
        if (!bundles || Object.keys(bundles).length === 0) {
            throw utils_1.createError('@web/rollup-plugin-html did not output any bundles to be injected');
        }
        if (!modernOutput || !legacyOutput) {
            throw utils_1.createError('Rollup is configured to output multiple builds, set the modernOutput and legacyOutput options' +
                ' to configure how they should be loaded by the polyfills loader.');
        }
        if (!bundles[modernOutput.name])
            throw bundleNotFoundError(modernOutput.name);
        modernOutput.type;
        modern = createEntrypoints(bundles[modernOutput.name], modernOutput.type);
        /** @type {LegacyEntrypoint[]} */
        legacy = [];
        const legacyOutputIterator = Array.isArray(legacyOutput) ? legacyOutput : [legacyOutput];
        for (const output of legacyOutputIterator) {
            if (!bundles[output.name])
                throw bundleNotFoundError(output.name);
            const entrypoint = createLegacyEntrypoints(bundles[output.name], output.test, output.type);
            legacy.push(entrypoint);
        }
    }
    return { modern, legacy, polyfills, externalLoaderScript: pluginOptions.externalLoaderScript };
}
exports.createPolyfillsLoaderConfig = createPolyfillsLoaderConfig;
//# sourceMappingURL=createPolyfillsLoaderConfig.js.map