"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.injectServiceWorkerRegistration = void 0;
const path_1 = __importDefault(require("path"));
const parse5_utils_1 = require("@web/parse5-utils");
function injectServiceWorkerRegistration(args) {
    const { document, serviceWorkerPath, outputDir, htmlFileName } = args;
    const body = parse5_utils_1.findElement(document, e => parse5_utils_1.getTagName(e) === 'body');
    if (!body) {
        throw new Error('Missing body in HTML document.');
    }
    let serviceWorkerUrl = path_1.default.relative(outputDir, serviceWorkerPath);
    serviceWorkerUrl = path_1.default.relative(path_1.default.dirname(htmlFileName), serviceWorkerUrl);
    serviceWorkerUrl = serviceWorkerUrl.split(path_1.default.sep).join('/');
    const code = `
    if ('serviceWorker' in navigator) {
      window.addEventListener('load', function() {
        navigator.serviceWorker
          .register('${serviceWorkerUrl}')
          .then(function() {
            console.log('ServiceWorker registered from "${serviceWorkerUrl}".');
          })
          .catch(function(err) {
            console.log('ServiceWorker registration failed: ', err);
          });
      });
    }
  `;
    const script = parse5_utils_1.createScript({}, code);
    parse5_utils_1.setAttribute(script, 'inject-service-worker', '');
    parse5_utils_1.appendChild(body, script);
}
exports.injectServiceWorkerRegistration = injectServiceWorkerRegistration;
//# sourceMappingURL=injectServiceWorkerRegistration.js.map