"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.injectBundles = exports.createLoadScript = void 0;
const parse5_utils_1 = require("@web/parse5-utils");
const utils_1 = require("../utils");
function createLoadScript(src, format, attributes) {
    const attributesObject = {};
    if (attributes) {
        for (const attribute of attributes) {
            attributesObject[attribute.name] = attribute.value;
        }
    }
    if (['es', 'esm', 'module'].includes(format)) {
        return parse5_utils_1.createScript(Object.assign({ type: 'module', src }, attributesObject));
    }
    if (['system', 'systemjs'].includes(format)) {
        return parse5_utils_1.createScript({}, `System.import(${JSON.stringify(src)});`);
    }
    return parse5_utils_1.createScript({ src, defer: '' });
}
exports.createLoadScript = createLoadScript;
function injectBundles(document, entrypointBundles) {
    const body = parse5_utils_1.findElement(document, e => parse5_utils_1.getTagName(e) === 'body');
    if (!body) {
        throw new Error('Missing body in HTML document.');
    }
    for (const { options, entrypoints } of Object.values(entrypointBundles)) {
        if (!options.format)
            throw utils_1.createError('Missing output format.');
        for (const entrypoint of entrypoints) {
            parse5_utils_1.appendChild(body, createLoadScript(entrypoint.importPath, options.format, entrypoint.attributes));
        }
    }
}
exports.injectBundles = injectBundles;
//# sourceMappingURL=injectBundles.js.map