"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.injectAbsoluteBaseUrl = void 0;
const parse5_utils_1 = require("@web/parse5-utils");
function isAbsoluteableNode(node) {
    const metaAttributes = ['og:url', 'og:image'];
    switch (parse5_utils_1.getTagName(node)) {
        case 'link':
            if (parse5_utils_1.getAttribute(node, 'rel') === 'canonical' && parse5_utils_1.getAttribute(node, 'href')) {
                return true;
            }
            return false;
        case 'meta':
            if (metaAttributes.includes(parse5_utils_1.getAttribute(node, 'property')) &&
                parse5_utils_1.getAttribute(node, 'content')) {
                return true;
            }
            return false;
        default:
            return false;
    }
}
function injectAbsoluteBaseUrl(document, absoluteBaseUrl) {
    const nodes = parse5_utils_1.findElements(document, isAbsoluteableNode);
    for (const node of nodes) {
        switch (parse5_utils_1.getTagName(node)) {
            case 'link':
                parse5_utils_1.setAttribute(node, 'href', new URL(parse5_utils_1.getAttribute(node, 'href'), absoluteBaseUrl).href);
                break;
            case 'meta':
                parse5_utils_1.setAttribute(node, 'content', new URL(parse5_utils_1.getAttribute(node, 'content'), absoluteBaseUrl).href);
                break;
        }
    }
}
exports.injectAbsoluteBaseUrl = injectAbsoluteBaseUrl;
//# sourceMappingURL=injectAbsoluteBaseUrl.js.map