"use strict";
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getOutputHTML = void 0;
const injectBundles_1 = require("./injectBundles");
const parse5_1 = require("parse5");
const html_minifier_terser_1 = require("html-minifier-terser");
const injectedUpdatedAssetPaths_1 = require("./injectedUpdatedAssetPaths");
const injectAbsoluteBaseUrl_1 = require("./injectAbsoluteBaseUrl");
const hashInlineScripts_1 = require("./hashInlineScripts");
const injectServiceWorkerRegistration_1 = require("./injectServiceWorkerRegistration");
async function getOutputHTML(params) {
    const { pluginOptions, entrypointBundles, externalTransformHtmlFns, input, outputDir, emittedAssets, defaultInjectDisabled, serviceWorkerPath, injectServiceWorker, absolutePathPrefix, strictCSPInlineScripts, } = params;
    const { default: defaultBundle } = entrypointBundles, multiBundles = __rest(entrypointBundles, ["default"]);
    const { absoluteSocialMediaUrls = true, rootDir = process.cwd() } = pluginOptions;
    // inject rollup output into HTML
    let document = parse5_1.parse(input.html);
    if (pluginOptions.extractAssets !== false) {
        injectedUpdatedAssetPaths_1.injectedUpdatedAssetPaths({
            document,
            input,
            outputDir,
            rootDir,
            emittedAssets,
            absolutePathPrefix,
            publicPath: pluginOptions.publicPath,
        });
    }
    if (!defaultInjectDisabled) {
        injectBundles_1.injectBundles(document, entrypointBundles);
    }
    if (absoluteSocialMediaUrls && pluginOptions.absoluteBaseUrl) {
        injectAbsoluteBaseUrl_1.injectAbsoluteBaseUrl(document, pluginOptions.absoluteBaseUrl);
    }
    if (injectServiceWorker && serviceWorkerPath) {
        injectServiceWorkerRegistration_1.injectServiceWorkerRegistration({
            document,
            outputDir,
            serviceWorkerPath,
            htmlFileName: input.name,
        });
    }
    let outputHtml = parse5_1.serialize(document);
    const transforms = [...(externalTransformHtmlFns !== null && externalTransformHtmlFns !== void 0 ? externalTransformHtmlFns : [])];
    if (pluginOptions.transformHtml) {
        if (Array.isArray(pluginOptions.transformHtml)) {
            transforms.push(...pluginOptions.transformHtml);
        }
        else {
            transforms.push(pluginOptions.transformHtml);
        }
    }
    // run transform functions on output HTML
    for (const transform of transforms) {
        outputHtml = await transform(outputHtml, {
            bundle: defaultBundle,
            bundles: multiBundles,
            htmlFileName: input.name,
        });
    }
    if (pluginOptions.minify) {
        outputHtml = await html_minifier_terser_1.minify(outputHtml, {
            collapseWhitespace: true,
            removeComments: true,
            removeRedundantAttributes: true,
            removeScriptTypeAttributes: true,
            removeStyleLinkTypeAttributes: true,
            useShortDoctype: true,
            minifyCSS: true,
            minifyJS: true,
        });
    }
    if (strictCSPInlineScripts) {
        document = parse5_1.parse(outputHtml);
        hashInlineScripts_1.hashInlineScripts(document);
        outputHtml = parse5_1.serialize(document);
    }
    return outputHtml;
}
exports.getOutputHTML = getOutputHTML;
//# sourceMappingURL=getOutputHTML.js.map