"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getEntrypointBundles = exports.createImportPath = void 0;
const path_1 = __importDefault(require("path"));
const utils_1 = require("../utils");
const utils_2 = require("./utils");
function createImportPath(params) {
    const { publicPath, outputDir, fileOutputDir, htmlFileName, fileName } = params;
    const pathFromMainToFileDir = path_1.default.relative(outputDir, fileOutputDir);
    let importPath;
    if (publicPath) {
        importPath = utils_2.toBrowserPath(path_1.default.join(publicPath, pathFromMainToFileDir, fileName));
    }
    else {
        const pathFromHtmlToOutputDir = path_1.default.relative(path_1.default.dirname(htmlFileName), pathFromMainToFileDir);
        importPath = utils_2.toBrowserPath(path_1.default.join(pathFromHtmlToOutputDir, fileName));
    }
    if (importPath.startsWith('http') || importPath.startsWith('/') || importPath.startsWith('.')) {
        return importPath;
    }
    return `./${importPath}`;
}
exports.createImportPath = createImportPath;
function getEntrypointBundles(params) {
    var _a;
    const { pluginOptions, generatedBundles, inputModuleIds, outputDir, htmlFileName } = params;
    const entrypointBundles = {};
    for (const { name, options, bundle } of generatedBundles) {
        if (!options.format) {
            throw utils_1.createError('Missing module format');
        }
        const entrypoints = [];
        for (const chunkOrAsset of Object.values(bundle)) {
            if (chunkOrAsset.type === 'chunk') {
                const chunk = chunkOrAsset;
                if (chunk.isEntry && chunk.facadeModuleId !== utils_1.NOOP_IMPORT.importPath) {
                    const found = inputModuleIds.find(mod => mod.importPath === chunk.facadeModuleId);
                    if (chunk.facadeModuleId && found) {
                        const importPath = createImportPath({
                            publicPath: pluginOptions.publicPath,
                            outputDir,
                            fileOutputDir: (_a = options.dir) !== null && _a !== void 0 ? _a : '',
                            htmlFileName,
                            fileName: chunkOrAsset.fileName,
                        });
                        entrypoints.push({ importPath, chunk: chunkOrAsset, attributes: found.attributes });
                    }
                }
            }
        }
        entrypointBundles[name] = { name, options, bundle, entrypoints };
    }
    return entrypointBundles;
}
exports.getEntrypointBundles = getEntrypointBundles;
//# sourceMappingURL=getEntrypointBundles.js.map