"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.emitAssets = void 0;
const path_1 = __importDefault(require("path"));
async function emitAssets(inputs, options) {
    const emittedStaticAssets = new Map();
    const emittedHashedAssets = new Map();
    const emittedStaticAssetNames = new Set();
    const transforms = [];
    if (options.transformAsset) {
        if (Array.isArray(options.transformAsset)) {
            transforms.push(...options.transformAsset);
        }
        else {
            transforms.push(options.transformAsset);
        }
    }
    const staticAssets = [];
    const hashedAssets = [];
    for (const input of inputs) {
        for (const asset of input.assets) {
            if (asset.hashed) {
                hashedAssets.push(asset);
            }
            else {
                staticAssets.push(asset);
            }
        }
    }
    // ensure static assets are last because of https://github.com/rollup/rollup/issues/3853
    const allAssets = [...hashedAssets, ...staticAssets];
    for (const asset of allAssets) {
        const map = asset.hashed ? emittedHashedAssets : emittedStaticAssets;
        if (!map.has(asset.filePath)) {
            let source = asset.content;
            // run user's transform functions
            for (const transform of transforms) {
                const result = await transform(asset.content, asset.filePath);
                if (result != null) {
                    source = typeof result === 'string' ? Buffer.from(result, 'utf-8') : result;
                }
            }
            let ref;
            let basename = path_1.default.basename(asset.filePath);
            if (asset.hashed) {
                ref = this.emitFile({ type: 'asset', name: basename, source });
            }
            else {
                // ensure the output filename is unique
                let i = 1;
                while (emittedStaticAssetNames.has(basename)) {
                    const ext = path_1.default.extname(basename);
                    basename = `${basename.replace(ext, '')}${i}${ext}`;
                    i += 1;
                }
                emittedStaticAssetNames.add(basename);
                const fileName = `assets/${basename}`;
                ref = this.emitFile({ type: 'asset', name: basename, fileName, source });
            }
            map.set(asset.filePath, this.getFileName(ref));
        }
    }
    return { static: emittedStaticAssets, hashed: emittedHashedAssets };
}
exports.emitAssets = emitAssets;
//# sourceMappingURL=emitAssets.js.map