"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createHTMLOutput = exports.createHTMLAsset = void 0;
const getEntrypointBundles_1 = require("./getEntrypointBundles");
const getOutputHTML_1 = require("./getOutputHTML");
const utils_1 = require("../utils");
async function createHTMLAsset(params) {
    const { outputDir, input, emittedAssets, generatedBundles, externalTransformHtmlFns, pluginOptions, defaultInjectDisabled, serviceWorkerPath, injectServiceWorker, absolutePathPrefix, strictCSPInlineScripts, } = params;
    if (generatedBundles.length === 0) {
        throw utils_1.createError('Cannot output HTML when no bundles have been generated');
    }
    const entrypointBundles = getEntrypointBundles_1.getEntrypointBundles({
        pluginOptions,
        generatedBundles,
        inputModuleIds: input.moduleImports,
        outputDir,
        htmlFileName: input.name,
    });
    const outputHtml = await getOutputHTML_1.getOutputHTML({
        pluginOptions,
        entrypointBundles,
        input,
        outputDir,
        emittedAssets,
        externalTransformHtmlFns,
        defaultInjectDisabled,
        serviceWorkerPath,
        injectServiceWorker,
        absolutePathPrefix,
        strictCSPInlineScripts,
    });
    return { fileName: input.name, name: input.name, source: outputHtml, type: 'asset' };
}
exports.createHTMLAsset = createHTMLAsset;
async function createHTMLOutput(params) {
    return Promise.all(params.inputs.map(input => createHTMLAsset(Object.assign(Object.assign({}, params), { input }))));
}
exports.createHTMLOutput = createHTMLOutput;
//# sourceMappingURL=createHTMLOutput.js.map