"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.normalizeInputOptions = void 0;
const utils_1 = require("../utils");
function normalizeInputOptions(pluginOptions, rollupInput) {
    if (pluginOptions.input == null) {
        if (rollupInput == null) {
            throw utils_1.createError('Missing input option in rollup or in HTML plugin options.');
        }
        if (typeof rollupInput === 'string') {
            return [{ path: rollupInput }];
        }
        if (Array.isArray(rollupInput)) {
            return rollupInput.map(path => ({ path }));
        }
        if (typeof rollupInput === 'object') {
            return Object.entries(rollupInput).map(([name, path]) => ({ name, path }));
        }
        throw utils_1.createError('Unable to parse rollup input option');
    }
    if (Array.isArray(pluginOptions.input)) {
        return pluginOptions.input.map(input => {
            if (typeof input === 'string') {
                return { path: input };
            }
            return input;
        });
    }
    if (typeof pluginOptions.input === 'object') {
        return [pluginOptions.input];
    }
    if (typeof pluginOptions.input === 'string') {
        return [{ path: pluginOptions.input }];
    }
    throw utils_1.createError('Unable to parse html plugin input option');
}
exports.normalizeInputOptions = normalizeInputOptions;
//# sourceMappingURL=normalizeInputOptions.js.map