"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractModulesAndAssets = void 0;
const path_1 = __importDefault(require("path"));
const parse5_1 = require("parse5");
const extractModules_1 = require("./extractModules");
const extractAssets_1 = require("./extractAssets");
function extractModulesAndAssets(params) {
    const { html, htmlFilePath, rootDir, absolutePathPrefix } = params;
    const htmlDir = path_1.default.dirname(htmlFilePath);
    const document = parse5_1.parse(html);
    // extract functions mutate the AST
    const { moduleImports, inlineModules } = extractModules_1.extractModules({
        document,
        htmlDir,
        rootDir,
        absolutePathPrefix,
    });
    const assets = params.extractAssets
        ? extractAssets_1.extractAssets({ document, htmlDir, htmlFilePath, rootDir, absolutePathPrefix })
        : [];
    // turn mutated AST back to a string
    const updatedHtmlString = parse5_1.serialize(document);
    return { moduleImports, inlineModules, assets, htmlWithoutModules: updatedHtmlString };
}
exports.extractModulesAndAssets = extractModulesAndAssets;
//# sourceMappingURL=extractModulesAndAssets.js.map