"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractModules = void 0;
const parse5_utils_1 = require("@web/parse5-utils");
const path_1 = __importDefault(require("path"));
const crypto_1 = __importDefault(require("crypto"));
const utils_1 = require("../../assets/utils");
const parse5_utils_2 = require("@web/parse5-utils");
function createContentHash(content) {
    return crypto_1.default.createHash('md5').update(content).digest('hex');
}
function isAbsolute(src) {
    try {
        new URL(src);
        return true;
    }
    catch (_a) {
        return false;
    }
}
function extractModules(params) {
    const { document, htmlDir, rootDir, absolutePathPrefix } = params;
    const scriptNodes = parse5_utils_1.findElements(document, e => parse5_utils_1.getTagName(e) === 'script' && parse5_utils_1.getAttribute(e, 'type') === 'module');
    const moduleImports = [];
    const inlineModules = [];
    for (const scriptNode of scriptNodes) {
        const src = parse5_utils_1.getAttribute(scriptNode, 'src');
        const allAttributes = parse5_utils_2.getAttributes(scriptNode);
        const attributes = [];
        for (const attributeName of Object.keys(allAttributes)) {
            if (attributeName !== 'src' && attributeName !== 'type') {
                attributes.push({ name: attributeName, value: allAttributes[attributeName] });
            }
        }
        if (!src) {
            // turn inline module (<script type="module"> ...code ... </script>)
            const code = parse5_utils_1.getTextContent(scriptNode);
            // inline modules should be relative to the HTML file to resolve relative imports
            // we make it unique with a content hash, so that duplicate modules are deduplicated
            const importPath = path_1.default.posix.join(htmlDir, `/inline-module-${createContentHash(code)}.js`);
            if (!inlineModules.find(tag => tag.importPath === importPath)) {
                inlineModules.push({
                    importPath,
                    attributes,
                    code,
                });
            }
            parse5_utils_1.remove(scriptNode);
        }
        else {
            if (!isAbsolute(src)) {
                // external script <script type="module" src="./foo.js"></script>
                const importPath = utils_1.resolveAssetFilePath(src, htmlDir, rootDir, absolutePathPrefix);
                moduleImports.push({
                    importPath,
                    attributes,
                });
                parse5_utils_1.remove(scriptNode);
            }
        }
    }
    return { moduleImports, inlineModules };
}
exports.extractModules = extractModules;
//# sourceMappingURL=extractModules.js.map