"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractAssets = void 0;
const parse5_1 = require("parse5");
const fs_1 = __importDefault(require("fs"));
const path_1 = __importDefault(require("path"));
const utils_1 = require("../../assets/utils");
function extractAssets(params) {
    const assetNodes = utils_1.findAssets(params.document);
    const allAssets = [];
    for (const node of assetNodes) {
        const sourcePaths = utils_1.getSourcePaths(node);
        for (const sourcePath of sourcePaths) {
            const filePath = utils_1.resolveAssetFilePath(sourcePath, params.htmlDir, params.rootDir, params.absolutePathPrefix);
            const hashed = utils_1.isHashedAsset(node);
            const alreadyHandled = allAssets.find(a => a.filePath === filePath && a.hashed === hashed);
            if (!alreadyHandled) {
                try {
                    fs_1.default.accessSync(filePath);
                }
                catch (error) {
                    const elStr = parse5_1.serialize(node);
                    const htmlPath = path_1.default.relative(process.cwd(), params.htmlFilePath);
                    throw new Error(`Could not find ${filePath} referenced from HTML file ${htmlPath} from element ${elStr}.`);
                }
                const content = fs_1.default.readFileSync(filePath);
                allAssets.push({ filePath, hashed, content });
            }
        }
    }
    return allAssets;
}
exports.extractAssets = extractAssets;
//# sourceMappingURL=extractAssets.js.map