"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.addRollupInput = void 0;
const utils_1 = require("../utils");
function fromEntries(entries) {
    const obj = {};
    for (const [k, v] of entries) {
        obj[k] = v;
    }
    return obj;
}
function addRollupInput(inputOptions, inputModuleIds) {
    var _a;
    // Add input module ids to existing input option, whether it's a string, array or object
    // this way you can use multiple html plugins all adding their own inputs
    if (!inputOptions.input) {
        return Object.assign(Object.assign({}, inputOptions), { input: inputModuleIds.map(mod => mod.importPath) });
    }
    if (typeof inputOptions.input === 'string') {
        return Object.assign(Object.assign({}, inputOptions), { input: [
                ...(((_a = inputOptions === null || inputOptions === void 0 ? void 0 : inputOptions.input) === null || _a === void 0 ? void 0 : _a.endsWith('.html')) ? [] : [inputOptions.input]),
                ...inputModuleIds.map(mod => mod.importPath),
            ] });
    }
    if (Array.isArray(inputOptions.input)) {
        return Object.assign(Object.assign({}, inputOptions), { input: [...inputOptions.input, ...inputModuleIds.map(mod => mod.importPath)] });
    }
    if (typeof inputOptions.input === 'object') {
        return Object.assign(Object.assign({}, inputOptions), { input: Object.assign(Object.assign({}, inputOptions.input), fromEntries(inputModuleIds
                .map(mod => mod.importPath)
                .map(i => [i.split('/').slice(-1)[0].split('.')[0], i]))) });
    }
    throw utils_1.createError(`Unknown rollup input type. Supported inputs are string, array and object.`);
}
exports.addRollupInput = addRollupInput;
//# sourceMappingURL=addRollupInput.js.map