"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.findAssets = exports.getSourcePaths = exports.getSourceAttribute = exports.resolveAssetFilePath = exports.isHashedAsset = void 0;
const path_1 = __importDefault(require("path"));
const parse5_utils_1 = require("@web/parse5-utils");
const utils_1 = require("../utils");
const v8_1 = require("v8");
const hashedLinkRels = ['stylesheet'];
const linkRels = [...hashedLinkRels, 'icon', 'manifest', 'apple-touch-icon', 'mask-icon'];
function getSrcSetUrls(srcset) {
    if (!srcset) {
        return [];
    }
    const srcsetParts = srcset.includes(',') ? srcset.split(',') : [srcset];
    const urls = srcsetParts
        .map(url => url.trim())
        .map(url => (url.includes(' ') ? url.split(' ')[0] : url));
    return urls;
}
function extractFirstUrlOfSrcSet(node) {
    const srcset = parse5_utils_1.getAttribute(node, 'srcset');
    if (!srcset) {
        return '';
    }
    const urls = getSrcSetUrls(srcset);
    return urls[0];
}
function isAsset(node) {
    var _a, _b, _c, _d, _e, _f;
    let path = '';
    switch (parse5_utils_1.getTagName(node)) {
        case 'img':
            path = (_a = parse5_utils_1.getAttribute(node, 'src')) !== null && _a !== void 0 ? _a : '';
            break;
        case 'source':
            path = (_b = extractFirstUrlOfSrcSet(node)) !== null && _b !== void 0 ? _b : '';
            break;
        case 'link':
            if (linkRels.includes((_c = parse5_utils_1.getAttribute(node, 'rel')) !== null && _c !== void 0 ? _c : '')) {
                path = (_d = parse5_utils_1.getAttribute(node, 'href')) !== null && _d !== void 0 ? _d : '';
            }
            break;
        case 'meta':
            if (parse5_utils_1.getAttribute(node, 'property') === 'og:image' && parse5_utils_1.getAttribute(node, 'content')) {
                path = (_e = parse5_utils_1.getAttribute(node, 'content')) !== null && _e !== void 0 ? _e : '';
            }
            break;
        case 'script':
            if (parse5_utils_1.getAttribute(node, 'type') !== 'module' && parse5_utils_1.getAttribute(node, 'src')) {
                path = (_f = parse5_utils_1.getAttribute(node, 'src')) !== null && _f !== void 0 ? _f : '';
            }
            break;
        default:
            return false;
    }
    if (!path) {
        return false;
    }
    try {
        new URL(path);
        return false;
    }
    catch (e) {
        return true;
    }
}
function isHashedAsset(node) {
    switch (parse5_utils_1.getTagName(node)) {
        case 'img':
            return true;
        case 'source':
            return true;
        case 'script':
            return true;
        case 'link':
            return hashedLinkRels.includes(parse5_utils_1.getAttribute(node, 'rel'));
        case 'meta':
            return true;
        default:
            return false;
    }
}
exports.isHashedAsset = isHashedAsset;
function resolveAssetFilePath(browserPath, htmlDir, projectRootDir, absolutePathPrefix) {
    const _browserPath = absolutePathPrefix && browserPath[0] === '/'
        ? '/' + path_1.default.posix.relative(absolutePathPrefix, browserPath)
        : browserPath;
    return path_1.default.join(_browserPath.startsWith('/') ? projectRootDir : htmlDir, _browserPath.split('/').join(path_1.default.sep));
}
exports.resolveAssetFilePath = resolveAssetFilePath;
function getSourceAttribute(node) {
    switch (parse5_utils_1.getTagName(node)) {
        case 'img': {
            return 'src';
        }
        case 'source': {
            return 'srcset';
        }
        case 'link': {
            return 'href';
        }
        case 'script': {
            return 'src';
        }
        case 'meta': {
            return 'content';
        }
        default:
            throw new Error(`Unknown node with tagname ${parse5_utils_1.getTagName(node)}`);
    }
}
exports.getSourceAttribute = getSourceAttribute;
function getSourcePaths(node) {
    const key = getSourceAttribute(node);
    const src = parse5_utils_1.getAttribute(node, key);
    if (typeof key !== 'string' || src === '') {
        throw utils_1.createError(`Missing attribute ${key} in element ${v8_1.serialize(node)}`);
    }
    let paths = [];
    if (src) {
        paths = key !== 'srcset' ? [src] : getSrcSetUrls(src);
    }
    return paths;
}
exports.getSourcePaths = getSourcePaths;
function findAssets(document) {
    return parse5_utils_1.findElements(document, isAsset);
}
exports.findAssets = findAssets;
//# sourceMappingURL=utils.js.map