"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.hasFileOfType = exports.getScriptFileType = exports.cleanImportPath = exports.createContentHash = exports.fileTypes = exports.noModuleSupportTest = void 0;
const parse5_utils_1 = require("@web/parse5-utils");
const crypto_1 = __importDefault(require("crypto"));
exports.noModuleSupportTest = "!('noModule' in HTMLScriptElement.prototype)";
exports.fileTypes = {
    SCRIPT: 'script',
    MODULE: 'module',
    MODULESHIM: 'module-shim',
    SYSTEMJS: 'systemjs',
};
function createContentHash(content) {
    return crypto_1.default.createHash('md5').update(content).digest('hex');
}
exports.createContentHash = createContentHash;
function cleanImportPath(importPath) {
    if (importPath.startsWith('/')) {
        return importPath;
    }
    if (importPath.startsWith('../') || importPath.startsWith('./')) {
        return importPath;
    }
    return `./${importPath}`;
}
exports.cleanImportPath = cleanImportPath;
function getScriptFileType(script) {
    return parse5_utils_1.getAttribute(script, 'type') === 'module' ? exports.fileTypes.MODULE : exports.fileTypes.SCRIPT;
}
exports.getScriptFileType = getScriptFileType;
function hasFileOfType(cfg, type) {
    var _a;
    return (((_a = cfg.modern) === null || _a === void 0 ? void 0 : _a.files.some(f => f.type === type)) ||
        (cfg.legacy && cfg.legacy.some(e => e.files.some(f => f.type === type))));
}
exports.hasFileOfType = hasFileOfType;
//# sourceMappingURL=utils.js.map