import { Attribute } from 'parse5';
export interface PolyfillsLoaderConfig {
    modern?: ModernEntrypoint;
    legacy?: LegacyEntrypoint[];
    polyfills?: PolyfillsConfig;
    polyfillsDir?: string;
    relativePathToPolyfills?: string;
    minify?: boolean;
    preload?: boolean;
    externalLoaderScript?: boolean;
}
export interface PolyfillsConfig {
    custom?: PolyfillConfig[];
    hash?: boolean;
    coreJs?: boolean;
    regeneratorRuntime?: boolean | 'always';
    webcomponents?: boolean;
    fetch?: boolean;
    abortController?: boolean;
    intersectionObserver?: boolean;
    resizeObserver?: boolean;
    dynamicImport?: boolean;
    systemjs?: boolean;
    systemjsExtended?: boolean;
    esModuleShims?: boolean | 'always';
    constructibleStylesheets?: boolean;
    shadyCssCustomStyle?: boolean;
}
export interface PolyfillConfig {
    name: string;
    path: string | string[];
    test?: string;
    fileType?: FileType;
    minify?: boolean;
    initializer?: string;
}
export interface ModernEntrypoint {
    files: File[];
}
export interface LegacyEntrypoint {
    test: string;
    files: File[];
}
export declare type FileType = 'script' | 'module' | 'systemjs' | 'module-shim';
export interface File {
    type: FileType;
    path: string;
    attributes?: Attribute[];
}
export interface GeneratedFile extends File {
    content: string;
}
export interface PolyfillFile extends GeneratedFile {
    name: string;
    test?: string;
    initializer?: string;
}
export interface PolyfillsLoader {
    code: string;
    polyfillFiles: GeneratedFile[];
}
//# sourceMappingURL=types.d.ts.map