"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createBrowserImport = exports.createError = void 0;
const path_1 = __importDefault(require("path"));
const path_is_inside_1 = __importDefault(require("path-is-inside"));
function createError(msg) {
    return new Error(`[@web/dev-server-storybook] ${msg}`);
}
exports.createError = createError;
function createBrowserImport(rootDir, filePath) {
    if (!path_is_inside_1.default(filePath, rootDir)) {
        throw createError(`The file ${filePath} is not accessible by the browser because it is outside the root directory ${rootDir}. ` +
            'Change the rootDir option to include this directory.');
    }
    const relativeFilePath = path_1.default.relative(rootDir, filePath);
    const browserPath = relativeFilePath.split(path_1.default.sep).join('/');
    return `./${browserPath}`;
}
exports.createBrowserImport = createBrowserImport;
//# sourceMappingURL=utils.js.map