"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.injectExportsOrder = void 0;
const es_module_lexer_1 = require("es-module-lexer");
async function injectExportsOrder(source, filePath) {
    const [, exports] = await es_module_lexer_1.parse(source, filePath);
    if (exports.some(e => e.n === '__namedExportsOrder')) {
        // user has defined named exports already
        return null;
    }
    const orderedExports = exports.filter(e => (e === null || e === void 0 ? void 0 : e.n) !== 'default');
    const exportsArray = `['${orderedExports.map(({ n }) => n).join("', '")}']`;
    return `${source};\nexport const __namedExportsOrder = ${exportsArray};`;
}
exports.injectExportsOrder = injectExportsOrder;
//# sourceMappingURL=injectExportsOrder.js.map