"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.findStories = void 0;
const globby_1 = __importDefault(require("globby"));
const path_1 = __importDefault(require("path"));
const utils_1 = require("../utils");
async function findStories(rootDir, mainJsPath, 
// eslint-disable-next-line @typescript-eslint/ban-types
stories) {
    const mainJsDir = path_1.default.dirname(mainJsPath);
    const storiesPatterns = typeof stories === 'function' ? await Promise.resolve(stories()) : stories;
    const storyPaths = await globby_1.default(storiesPatterns, { cwd: mainJsDir, absolute: false });
    const storyFilePaths = storyPaths.map(p => path_1.default.join(mainJsDir, p.split('/').join(path_1.default.sep)));
    if (storyFilePaths.length === 0) {
        throw utils_1.createError(`Could not find any stories with pattern ${storiesPatterns}`);
    }
    const storyImports = storyFilePaths.map(storyFilePath => utils_1.createBrowserImport(rootDir, storyFilePath));
    return { storyFilePaths, storyImports };
}
exports.findStories = findStories;
//# sourceMappingURL=findStories.js.map