"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.transformMdxToCsf = void 0;
const mdx_1 = __importDefault(require("@mdx-js/mdx"));
const core_1 = require("@babel/core");
const mdx_2 = require("@storybook/csf-tools/mdx");
const utils_1 = require("../utils");
const compilers = [mdx_2.createCompiler({})];
async function transformMdxToCsf(body, filePath) {
    // turn MDX to JSX
    const jsx = `
      import { React, mdx } from '@web/storybook-prebuilt/web-components.js';

      ${await mdx_1.default(body, { compilers, filepath: filePath })}
    `;
    // turn JSX to JS
    const babelResult = await core_1.transformAsync(jsx, {
        filename: filePath,
        sourceMaps: true,
        plugins: [require.resolve('@babel/plugin-transform-react-jsx')],
    });
    if (!(babelResult === null || babelResult === void 0 ? void 0 : babelResult.code)) {
        throw utils_1.createError(`Something went wrong while transforming ${filePath}`);
    }
    // rewrite imports
    let result = babelResult.code.replace(/@storybook\/addon-docs\/blocks/g, '@web/storybook-prebuilt/addon-docs/blocks.js');
    result = result.replace(/@storybook\/addon-docs/g, '@web/storybook-prebuilt/addon-docs/blocks.js');
    return result;
}
exports.transformMdxToCsf = transformMdxToCsf;
//# sourceMappingURL=transformMdxToCsf.js.map