"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createPreviewHtml = void 0;
const fs_1 = __importDefault(require("fs"));
const utils_1 = require("../utils");
function createPreviewImport(rootDir, previewJsPath) {
    if (!fs_1.default.existsSync(previewJsPath)) {
        return '';
    }
    const previewImport = utils_1.createBrowserImport(rootDir, previewJsPath);
    return `import * as preview from '${previewImport}'; registerPreviewEntry(preview);`;
}
function createPreviewHtml(pluginConfig, storybookConfig, rootDir, storyImports) {
    var _a, _b;
    const previewImport = createPreviewImport(rootDir, storybookConfig.previewJsPath);
    return `<!DOCTYPE html>
<html>
  <head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Storybook</title>

    <base target="_parent" />

    <style>
      :not(.sb-show-main) > .sb-main,
      :not(.sb-show-nopreview) > .sb-nopreview,
      :not(.sb-show-errordisplay) > .sb-errordisplay {
        display: none;
      }

      .sb-wrapper {
        position: fixed;
        top: 0;
        bottom: 0;
        left: 0;
        right: 0;
        padding: 20px;
        font-family: 'Nunito Sans', -apple-system, '.SFNSText-Regular', 'San Francisco',
          BlinkMacSystemFont, 'Segoe UI', 'Helvetica Neue', Helvetica, Arial, sans-serif;
        -webkit-font-smoothing: antialiased;
        overflow: auto;
      }

      .sb-heading {
        font-size: 14px;
        font-weight: 600;
        letter-spacing: 0.2px;
        margin: 10px 0;
        padding-right: 25px;
      }

      .sb-nopreview {
        display: flex;
        align-content: center;
        justify-content: center;
      }

      .sb-nopreview_main {
        margin: auto;
        padding: 30px;
        border-radius: 10px;
        background: rgba(0, 0, 0, 0.03);
      }

      .sb-nopreview_heading {
        text-align: center;
      }

      .sb-errordisplay {
        border: 20px solid rgb(187, 49, 49);
        background: #222;
        color: #fff;
        z-index: 999999;
      }

      .sb-errordisplay_code {
        padding: 10px;
        background: #000;
        color: #eee;
        font-family: 'Operator Mono', 'Fira Code Retina', 'Fira Code', 'FiraCode-Retina',
          'Andale Mono', 'Lucida Console', Consolas, Monaco, monospace;
      }

      .sb-errordisplay pre {
        white-space: pre-wrap;
      }
    </style>

    <script>
      try {
        if (window.top !== window) {
          window.__REACT_DEVTOOLS_GLOBAL_HOOK__ = window.top.__REACT_DEVTOOLS_GLOBAL_HOOK__;
          window.__VUE_DEVTOOLS_GLOBAL_HOOK__ = window.top.__VUE_DEVTOOLS_GLOBAL_HOOK__;
          window.top.__VUE_DEVTOOLS_CONTEXT__ = window.document;
        }
      } catch (e) {
        console.warn('unable to connect to top frame for connecting dev tools');
      }
    </script>
    ${(_a = storybookConfig.previewHead) !== null && _a !== void 0 ? _a : ''}
  </head>

  <body>
    ${(_b = storybookConfig.previewBody) !== null && _b !== void 0 ? _b : ''}
    <div id="root"></div>
    <div id="docs-root"></div>

    <div class="sb-errordisplay sb-wrapper">
      <div id="error-message" class="sb-heading"></div>
      <pre class="sb-errordisplay_code"><code id="error-stack"></code></pre>
    </div>

    <script type="module">
      import { registerPreviewEntry, configure } from '@web/storybook-prebuilt/${pluginConfig.type}.js';
      ${previewImport}
      ${storyImports.map((s, i) => `import * as stories${i} from '${s}';`).join('')}

      setTimeout(() => {
        configure(() => [${storyImports.map((s, i) => `stories${i}`)}], {}, false);
      });
    </script>
  </body>
</html>`;
}
exports.createPreviewHtml = createPreviewHtml;
//# sourceMappingURL=createPreviewHtml.js.map