"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createManagerHtml = void 0;
const fs_1 = __importDefault(require("fs"));
const utils_1 = require("../utils");
function createManagerImport(rootDir, managerJsPath) {
    if (!fs_1.default.existsSync(managerJsPath)) {
        return '';
    }
    const managerImport = utils_1.createBrowserImport(rootDir, managerJsPath);
    return `import '${managerImport}';`;
}
function createManagerHtml(storybookConfig, rootDir) {
    var _a;
    const managerImport = createManagerImport(rootDir, storybookConfig.managerJsPath);
    const addonImports = storybookConfig.mainJs.addons
        ? storybookConfig.mainJs.addons.map(a => `import '${a}';`).join('')
        : '';
    return `<!DOCTYPE html>
<html>
  <head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Storybook</title>

    <style>
      html,
      body {
        overflow: hidden;
        height: 100%;
        width: 100%;
        margin: 0;
        padding: 0;
      }
    </style>

    <style>
      #root[hidden],
      #docs-root[hidden] {
        display: none !important;
      }
    </style>
    ${(_a = storybookConfig.managerHead) !== null && _a !== void 0 ? _a : ''}
  </head>

  <body>
    <div id="root"></div>
    <div id="docs-root"></div>
    <script type="module">
      import '@web/storybook-prebuilt/manager.js';
      ${managerImport}
      ${addonImports}
    </script>
  </body>
</html>`;
}
exports.createManagerHtml = createManagerHtml;
//# sourceMappingURL=createManagerHtml.js.map