"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validatePluginConfig = void 0;
const utils_1 = require("../utils");
const types = ['preact', 'web-components'];
function validatePluginConfig(pluginConfig) {
    if (!pluginConfig) {
        throw utils_1.createError('Missing plugin configuration.');
    }
    if (typeof pluginConfig.type !== 'string') {
        throw utils_1.createError('Missing project type in config.');
    }
    if (!types.includes(pluginConfig.type)) {
        throw utils_1.createError(`Invalid project type ${pluginConfig.type}, supported types: ${types}`);
    }
}
exports.validatePluginConfig = validatePluginConfig;
//# sourceMappingURL=validatePluginConfig.js.map